/*
 * Decompiled with CFR 0.152.
 */
package jace.apple2e;

import jace.apple2e.VideoDHGR;
import jace.config.ConfigurableField;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;

public class VideoNTSC
extends VideoDHGR {
    @ConfigurableField(name="Le Chat Mauve", defaultValue="false", description="Enable Le Chat Mauve DHGR rendering support")
    public static boolean enableLeChatMauve = false;
    int[] scanline = new int[20];
    static int[] divBy28 = new int[560];
    int pos = 0;
    boolean colorActive = false;
    static int[][] pyOffset;
    public static final double MIN_Y = 0.0;
    public static final double MAX_Y = 1.0;
    public static final double MAX_I = 0.5957;
    public static final double MAX_Q = 0.5226;
    static int[][] color;
    static double[][] yiq;

    @Override
    protected void showBW(BufferedImage screen, int xOffset, int y, int dhgrWord) {
        if (xOffset == 0) {
            this.colorActive = false;
            this.pos = 0;
        }
        this.doDisplay(screen, xOffset, y, dhgrWord);
    }

    @Override
    protected void showDhgr(BufferedImage screen, int xOffset, int y, int dhgrWord) {
        if (xOffset == 0) {
            this.pos = 0;
            this.colorActive = true;
        }
        this.doDisplay(screen, xOffset, y, dhgrWord);
    }

    @Override
    protected void displayLores(BufferedImage screen, int xOffset, int y, int rowAddress) {
        if (xOffset == 0) {
            this.pos = 0;
            this.colorActive = true;
        }
        int c1 = this.memory.mainMemory.readByte(rowAddress + xOffset) & 0xFF;
        this.setFloatingBus((byte)c1);
        c1 = (y & 7) < 4 ? (c1 &= 0xF) : (c1 >>= 4);
        int c2 = this.memory.mainMemory.readByte(rowAddress + xOffset + 1) & 0xFF;
        this.setFloatingBus((byte)c2);
        c2 = (y & 7) < 4 ? (c2 &= 0xF) : (c2 >>= 4);
        int pat = c1 | c1 << 4 | c1 << 8 | (c1 & 3) << 12;
        this.scanline[xOffset >> 1] = pat |= (c2 & 0xC) << 12 | c2 << 16 | c2 << 20 | c2 << 24;
        ++this.pos;
    }

    private void doDisplay(BufferedImage screen, int xOffset, int y, int dhgrWord) {
        this.scanline[VideoNTSC.divBy28[xOffset]] = dhgrWord;
        ++this.pos;
    }

    @Override
    public void hblankStart(BufferedImage screen, int y, boolean isDirty) {
        if (isDirty) {
            this.renderScanline(screen, y);
        }
    }

    private void renderScanline(BufferedImage screen, int y) {
        DataBuffer b = screen.getRaster().getDataBuffer();
        if (this.pos > 20) {
            this.pos = 20;
        }
        int p = pyOffset[y][this.pos];
        this.pos = 0;
        if (this.colorActive) {
            int byteCounter = 0;
            for (int s = 0; s < 20; ++s) {
                int i;
                int add = 0;
                int bits = 0;
                if (this.hiresMode) {
                    bits = this.scanline[s] << 2;
                    if (s > 0) {
                        bits |= this.scanline[s - 1] >> 26 & 3;
                    }
                } else {
                    bits = this.scanline[s] << 3;
                    if (s > 0) {
                        bits |= this.scanline[s - 1] >> 25 & 7;
                    }
                }
                if (s < 19) {
                    add = this.scanline[s + 1] & 7;
                }
                boolean isBW = false;
                if (enableLeChatMauve) {
                    for (i = 0; i < 28; ++i) {
                        if (i % 7 == 0) {
                            isBW = !this.hiresMode && !this.useColor[byteCounter];
                            ++byteCounter;
                        }
                        if (isBW) {
                            b.setElem(p++, (bits & 8) == 0 ? BLACK : WHITE);
                        } else {
                            b.setElem(p++, color[i % 4][bits & 0x7F]);
                        }
                        bits >>= 1;
                        if (i != 20) continue;
                        bits |= add << (this.hiresMode ? 9 : 10);
                    }
                    continue;
                }
                for (i = 0; i < 28; ++i) {
                    b.setElem(p++, color[i % 4][bits & 0x7F]);
                    bits >>= 1;
                    if (i != 20) continue;
                    bits |= add << (this.hiresMode ? 9 : 10);
                }
            }
        } else {
            for (int s = 0; s < 20; ++s) {
                int bits = this.scanline[s];
                for (int i = 0; i < 28; ++i) {
                    b.setElem(p++, (bits & 1) == 0 ? BLACK : WHITE);
                    bits >>= 1;
                }
            }
        }
    }

    public static int yiqToRgb(double y, double i, double q) {
        int r = (int)(VideoNTSC.normalize(y + 0.956 * i + 0.621 * q, 0.0, 1.0) * 255.0);
        int g = (int)(VideoNTSC.normalize(y - 0.272 * i - 0.647 * q, 0.0, 1.0) * 255.0);
        int b = (int)(VideoNTSC.normalize(y - 1.105 * i + 1.702 * q, 0.0, 1.0) * 255.0);
        return r << 16 | g << 8 | b;
    }

    public static double normalize(double x, double minX, double maxX) {
        if (x < minX) {
            return minX;
        }
        if (x > maxX) {
            return maxX;
        }
        return x;
    }

    static {
        for (int i = 0; i < 560; ++i) {
            VideoNTSC.divBy28[i] = i / 28;
        }
        pyOffset = new int[192][21];
        for (int y = 0; y < 192; ++y) {
            for (int p = 0; p < 21; ++p) {
                VideoNTSC.pyOffset[y][p] = y * 560 + (20 - p) * 28;
            }
        }
        color = new int[4][128];
        yiq = new double[][]{{0.0, 0.0, 0.0}, {0.25, 0.5, 0.5}, {0.25, -0.5, 0.5}, {0.5, 0.0, 1.0}, {0.25, -0.5, -0.5}, {0.5, 0.0, 0.0}, {0.5, -1.0, 0.0}, {0.75, -0.5, 0.5}, {0.25, 0.5, -0.5}, {0.5, 1.0, 0.0}, {0.5, 0.0, 0.0}, {0.75, 0.5, 0.5}, {0.5, 0.0, -1.0}, {0.75, 0.5, -0.5}, {0.75, -0.5, -0.5}, {1.0, 0.0, 0.0}};
        int maxLevel = 16;
        for (int offset = 0; offset < 4; ++offset) {
            for (int pattern = 0; pattern < 128; ++pattern) {
                int level = (pattern & 1) + (pattern >> 1 & 1) * 2 + (pattern >> 2 & 1) * 3 + (pattern >> 3 & 1) * 4 + (pattern >> 4 & 1) * 3 + (pattern >> 5 & 1) * 2 + (pattern >> 6 & 1);
                int col = pattern >> 2 & 0xF;
                for (int rot = 0; rot < offset; ++rot) {
                    col = (col & 8) >> 3 | col << 1 & 0xF;
                }
                double y = yiq[col][0];
                VideoNTSC.color[offset][pattern] = 0xFF000000 | VideoNTSC.yiqToRgb(y, yiq[col][1] * 0.5957, yiq[col][2] * 0.5226);
            }
        }
    }
}

